/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.BlockTransformModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.behavior.BlockTransformModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ToolActionTransformModule(ToolAction action, SoundEvent sound, boolean requireGround, int eventId, ModifierCondition<IToolStackView> condition) implements BlockTransformModule,
ToolActionModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BLOCK_INTERACT, ModifierHooks.TOOL_ACTION);
    public static final RecordLoadable<ToolActionTransformModule> LOADER = RecordLoadable.create((RecordField)Loadables.TOOL_ACTION.requiredField("tool_action", ToolActionTransformModule::action), (RecordField)Loadables.SOUND_EVENT.requiredField("sound", ToolActionTransformModule::sound), (RecordField)BooleanLoadable.INSTANCE.requiredField("require_ground", ToolActionTransformModule::requireGround), (RecordField)IntLoadable.FROM_MINUS_ONE.defaultField("event_id", (Object)-1, ToolActionTransformModule::eventId), ModifierCondition.TOOL_FIELD, ToolActionTransformModule::new);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.condition.matches(tool, modifier) && this.action == toolAction;
    }

    @Override
    public boolean transform(IToolStackView tool, UseOnContext context, BlockState original, boolean playSound) {
        BlockState state;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockPos above = pos.m_7494_();
        if (this.requireGround && !(state = level.m_8055_(above)).m_247087_()) {
            return false;
        }
        Player player = context.m_43723_();
        BlockState transformed = original.getToolModifiedState(context, this.action, false);
        if (transformed != null) {
            if (playSound) {
                level.m_5594_(player, pos, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (this.eventId != -1) {
                    level.m_5898_(player, this.eventId, pos, 0);
                }
            }
            if (!level.f_46443_) {
                level.m_7731_(pos, transformed, 11);
                if (this.requireGround) {
                    level.m_46961_(above, true);
                }
                BlockTransformModifierHook.afterTransformBlock(tool, context, original, pos, this.action);
            }
            return true;
        }
        return false;
    }

    public RecordLoadable<ToolActionTransformModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(ToolAction action, SoundEvent sound) {
        return new Builder(action, sound);
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder> {
        private final ToolAction action;
        private final SoundEvent sound;
        private boolean requireGround;
        private int eventId = -1;

        public Builder requireGround() {
            this.requireGround = true;
            return this;
        }

        public ToolActionTransformModule build() {
            return new ToolActionTransformModule(this.action, this.sound, this.requireGround, this.eventId, this.condition);
        }

        private Builder(ToolAction action, SoundEvent sound) {
            this.action = action;
            this.sound = sound;
        }

        public Builder eventId(int eventId) {
            this.eventId = eventId;
            return this;
        }
    }
}

